/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.entitydata;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.class_1657;
import zabi.minecraft.extraalchemy.entitydata.ModEntityData;

public class PlayerProperties {
    public static final Codec<PlayerProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("magnetismEnabled").forGetter(PlayerProperties::isMagnetismEnabled), (App)Codec.FLOAT.fieldOf("xp_reserve").forGetter(PlayerProperties::getXpReserve)).apply((Applicative)instance, PlayerProperties::new));
    private boolean magnetismEnabled = true;
    private float xp_reserve = 0.0f;

    public PlayerProperties(boolean magnetism, float xp) {
        this.magnetismEnabled = magnetism;
        this.xp_reserve = xp;
    }

    public boolean isMagnetismEnabled() {
        return this.magnetismEnabled;
    }

    public void setMagnetismEnabled(boolean magnetismActive) {
        this.magnetismEnabled = magnetismActive;
    }

    public float getXpReserve() {
        return this.xp_reserve;
    }

    public int calculateXPDue(float xp) {
        float storable;
        int returnable = (int)(xp + this.xp_reserve);
        this.xp_reserve = storable = xp + this.xp_reserve - (float)returnable;
        return returnable;
    }

    public static PlayerProperties of(class_1657 player) {
        if (Objects.nonNull(player)) {
            return (PlayerProperties)player.getAttachedOrCreate(ModEntityData.PLAYER_PROPERTIES);
        }
        throw new NullPointerException("PlayerProperties can't be read from null players");
    }
}

